/****************************************************************************
*  LPC81x blinky IRQ demonstration program for LPC812 LPCXpresso board
*
*  1. Use SCT timer to generate a 10 msec timer tick (interrupt driven).
*  2. Toggle P0_7 (red LED) every 200 msec
*****************************************************************************/

#include "board.h"

#define match_value (SystemCoreClock/100)

extern void sct_fsm_init (void);

void sct_fsm_init (void)
{

	Chip_SCT_Init(LPC_SCT);

	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_32BIT_COUNTER | SCT_CONFIG_AUTOLIMIT_L);				/* UNIFIED */


	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_0, match_value);			/* match_0_ */
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, match_value);


	/* EVENT registers */

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0, ENABLE_STATE0);			/* U: --> state U_ENTRY */
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T)  ( SCT_EVECTRL_MATCH0	|
                                                                        SCT_COMBMODE_MATCH	|
                                                                        SCT_STATELD_0		    |
                                                                        SCT_STATEEV_0		    ));

	Chip_SCT_EnableEventInt(LPC_SCT, SCT_EVT_0);

	NVIC_EnableIRQ(SCT_IRQn);											/* enable SCT interrupt  */

	Chip_SCT_ClearControl(LPC_SCT , SCT_CTRL_HALT_L);

}


void SCT_IRQHandler (void)
{                                                  		/* SCT Interrupt Handler (10 msec) */
  static uint8_t cnt = 0;

    if (++cnt > 20)                                	/* 20 * 10 msec = 200 msec       */
    {
        cnt = 0;
        Chip_GPIO_SetPinToggle(LPC_GPIO_PORT,0, 7);    	/* toggle pin P0_7                */
    }

    Chip_SCT_ClearEventFlag(LPC_SCT, SCT_EVT_0);		/* clear event 0 flag             */
}


int main(void)
{
	/* Generic Initialization */
	SystemCoreClockUpdate();
	Board_Init();
  
	Chip_GPIO_SetPortDIR(LPC_GPIO_PORT, 0, 7, true);	 /* configure P0.7 (LED) as output  */

	sct_fsm_init();                      				/* Initialize the SCT using the code generated by Red State */

    while(1)
    {
    }
}
